def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions (replace with actual object names)
        object_1_pos = positions['object_1']  # Replace with actual object name
        object_2_pos = positions['object_2']  # Replace with actual object name

        # === Exploration Phase ===
        # Move to the location of object_1 to identify it
        print("[Exploration] Moving to object_1 location:", object_1_pos)
        obs, reward, done = move(env, 'robot', 'current_location', object_1_pos)
        if done:
            print("[Exploration] Task ended after moving to object_1!")
            return

        # Identify object_1
        print("[Exploration] Identifying object_1...")
        obs, reward, done = pick(env, 'object_1', object_1_pos, 'gripper')
        if done:
            print("[Exploration] Task ended after picking object_1!")
            return

        # Move to the location of object_2 to identify it
        print("[Exploration] Moving to object_2 location:", object_2_pos)
        obs, reward, done = move(env, 'robot', 'current_location', object_2_pos)
        if done:
            print("[Exploration] Task ended after moving to object_2!")
            return

        # Identify object_2
        print("[Exploration] Identifying object_2...")
        obs, reward, done = pick(env, 'object_2', object_2_pos, 'gripper')
        if done:
            print("[Exploration] Task ended after picking object_2!")
            return

        # === Task Completion Phase ===
        # Place object_1 at a designated location
        print("[Task] Placing object_1 at designated location...")
        obs, reward, done = place(env, 'object_1', 'designated_location')
        if done:
            print("[Task] Task ended after placing object_1!")
            return

        # Place object_2 at a designated location
        print("[Task] Placing object_2 at designated location...")
        obs, reward, done = place(env, 'object_2', 'designated_location')
        if done:
            print("[Task] Task ended after placing object_2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()