def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions (replace with actual object names)
        object_1_pos = positions['object_1']  # Replace with actual object name
        object_2_pos = positions['object_2']  # Replace with actual object name

        # Exploration Phase
        print("[Exploration] Moving to object_1 position to identify it.")
        obs, reward, done = move(env, 'room_a', object_1_pos)
        if done:
            print("[Exploration] Task ended after moving to object_1 position!")
            return

        print("[Exploration] Picking object_1 to know its weight.")
        obs, reward, done = pick(env, 'object_1', 'room_a')
        if done:
            print("[Exploration] Task ended after picking object_1!")
            return

        print("[Exploration] Moving to object_2 position to identify it.")
        obs, reward, done = move(env, 'room_a', object_2_pos)
        if done:
            print("[Exploration] Task ended after moving to object_2 position!")
            return

        print("[Exploration] Picking object_2 to know its durability.")
        obs, reward, done = pick(env, 'object_2', 'room_a')
        if done:
            print("[Exploration] Task ended after picking object_2!")
            return

        # Final actions to complete the task
        print("[Task] Placing object_1 at the designated location.")
        obs, reward, done = place(env, 'object_1', 'room_b')
        if done:
            print("[Task] Task ended after placing object_1!")
            return

        print("[Task] Placing object_2 at the designated location.")
        obs, reward, done = place(env, 'object_2', 'room_b')
        if done:
            print("[Task] Task ended after placing object_2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()