def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        object_1_pos = positions['object_1']  # Replace with actual object names
        object_2_pos = positions['object_2']  # Replace with actual object names
        drawer_pos = positions['drawer']      # Replace with actual drawer name

        # === Example Task Plan ===
        # 1) Move to object_1
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, 'initial_room', 'object_1_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # 2) Pick object_1
        print("[Task] Picking object_1...")
        obs, reward, done = pick(env, 'object_1', 'object_1_room', 'gripper')  # Replace with actual gripper name
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # 3) Move to drawer
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, 'object_1_room', 'drawer_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # 4) Open the drawer
        print("[Task] Opening the drawer...")
        obs, reward, done = pull(env, 'gripper', 'drawer')  # Replace with actual gripper and drawer names
        if done:
            print("[Task] Task ended after opening the drawer!")
            return

        # 5) Place object_1 in the drawer
        print("[Task] Placing object_1 in the drawer...")
        obs, reward, done = place(env, task, target_pos=drawer_pos)  # Adjust target_pos as needed
        if done:
            print("[Task] Task ended after placing object_1 in the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()