def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a robot and a drawer to interact with
        robot_position = positions['robot']
        drawer_position = positions['drawer']
        object_position = positions['object']

        # Step 1: Move to the drawer
        print("[Task] Moving to the drawer at:", drawer_position)
        obs, reward, done = move(env, robot_position, drawer_position)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 2: Pick the object
        print("[Task] Picking the object at:", object_position)
        obs, reward, done = pick(env, 'object', drawer_position, 'gripper')
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Place the object back
        print("[Task] Placing the object back at:", drawer_position)
        obs, reward, done = place(env, 'object', drawer_position)
        if done:
            print("[Task] Task ended after placing the object!")
            return

        # Step 4: Rotate the gripper if needed
        print("[Task] Rotating the gripper.")
        obs, reward, done = rotate(env, task, 'target_quat')
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Step 5: Pull the drawer if needed
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, 'drawer', drawer_position)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()