def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Example object positions fetched (update with actual object names)
        rubbish_bin_pos = positions['rubbish_bin']
        drawer_position = positions['drawer']
        object_to_pick = 'rubbish'  # This should match the actual name in your PDDL
        
        # Step 1: Move to the rubbish
        print(f"[Task] Moving to the {object_to_pick} at: {drawer_position}")
        obs, reward, done = move(env, task, obs.robot_position, drawer_position)
        if done: return

        # Step 2: Pick the rubbish
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, object_to_pick, drawer_position, 'gripper')
        if done: return

        # Step 3: Move to the rubbish bin
        print(f"[Task] Moving to the rubbish bin at: {rubbish_bin_pos}")
        obs, reward, done = move(env, task, obs.robot_position, rubbish_bin_pos)
        if done: return

        # Step 4: Place the rubbish in the bin
        print("[Task] Placing the rubbish in the bin.")
        obs, reward, done = place(env, object_to_pick, rubbish_bin_pos)
        if done: return

        # OPTIONAL: Implement collision detection and force calibration here if needed

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()