def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming "drawer" is the object to interact with
        drawer_pos = positions['drawer']
        robot_pos = positions['robot']

        # Step 1: Move the robot to the drawer
        print("[Task] Moving robot to drawer position:", drawer_pos)
        obs, reward, done = move(env, robot_pos, drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # Step 2: Rotate the gripper to the correct orientation
        target_quat = [0, 0, 0, 1]  # Assuming a target quaternion for the gripper
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Step 3: Pick the drawer handle
        print("[Task] Attempting to pick the drawer handle...")
        obs, reward, done = pick(env, 'drawer_handle', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return
        
        # Step 4: Open the drawer
        print("[Task] Attempting to pull open the drawer...")
        obs, reward, done = pull(env, 'drawer', drawer_pos)
        if done:
            print("[Task] Task ended after pulling the drawer open!")
            return

        # Step 5: Place the item in the drawer (if needed)
        print("[Task] Attempting to place item in the drawer...")
        obs, reward, done = place(env, 'item', drawer_pos)
        if done:
            print("[Task] Task ended after placing item in the drawer!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()