def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming the objects are named 'object1' and 'object2' and their positions retrieved.
        object1_pos = positions['object1']
        object2_pos = positions['object2']
        
        # === Example Task Plan ===
        
        # 1) Move to the object1 position
        print("[Task] Moving to object1 at:", object1_pos)
        obs, reward, done = move(env, 'robby', 'initial_room', 'object1_room')
        if done:
            print("[Task] Task ended after moving to object1!")
            return
        
        # 2) Pick up object1
        print("[Task] Picking up object1")
        obs, reward, done = pick(env, 'object1', 'object1_room', 'gripper')
        if done:
            print("[Task] Task ended after picking up object1!")
            return

        # 3) Move to the location to place object1
        print("[Task] Moving to placement location")
        obs, reward, done = move(env, 'robby', 'object1_room', 'placement_room')
        if done:
            print("[Task] Task ended after moving to placement location!")
            return
        
        # 4) Place object1
        print("[Task] Placing object1")
        obs, reward, done = place(env, 'object1', 'placement_room')
        if done:
            print("[Task] Task ended after placing object1!")
            return
        
        # 5) Move to object2 position
        print("[Task] Moving to object2 at:", object2_pos)
        obs, reward, done = move(env, 'robby', 'initial_room', 'object2_room')
        if done:
            print("[Task] Task ended after moving to object2!")
            return
        
        # 6) Pick up object2
        print("[Task] Picking up object2")
        obs, reward, done = pick(env, 'object2', 'object2_room', 'gripper')
        if done:
            print("[Task] Task ended after picking up object2!")
            return

        # 7) Move to the location to place object2
        print("[Task] Moving to placement location")
        obs, reward, done = move(env, 'robby', 'object2_room', 'placement_room')
        if done:
            print("[Task] Task ended after moving to placement location!")
            return
        
        # 8) Place object2
        print("[Task] Placing object2")
        obs, reward, done = place(env, 'object2', 'placement_room')
        if done:
            print("[Task] Task ended after placing object2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====") 

if __name__ == "__main__":
    run_skeleton_task()