def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define positions based on observed data
        robot_position = positions['robot']
        object_position = positions['object_1']  # Replace with your actual object key

        # Step 1: Move to the object
        print("[Task] Moving to the object at:", object_position)
        obs, reward, done = move(env, robot_position, object_position)
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Step 2: Pick the object
        print("[Task] Picking the object.")
        obs, reward, done = pick(env, 'object_1', object_position, 'gripper')  # Change 'object_1' to your target object
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Place the object at a new location
        target_location = positions['target_location']  # Define target location based on your logic
        print("[Task] Placing the object at:", target_location)
        obs, reward, done = place(env, 'object_1', target_location)  # Change 'object_1' to your target object
        if done:
            print("[Task] Task ended after placing the object!")
            return

        # Additional steps can be added here as needed
        
    except Exception as e:
        print(f"[Error] An error occurred during the task execution: {e}")
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")