def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Standardize object references
        if 'tomato1' in positions:
            tomato_obj = positions['tomato1']
        if 'bin' in positions:
            bin_obj = positions['bin']

        # Implement safety checks
        if np.linalg.norm(np.array(tomato_obj) - np.array(bin_obj)) < 0.1:
            print("Collision detected! Aborting task.")
            return
        
        # Move to the first object
        print("[Task] Moving to tomato1 at:", tomato_obj)
        obs, reward, done = move(env, task, current_pos, tomato_obj)

        if done:
            print("[Task] Task ended after moving to tomato1!")
            return
        
        # Pick up the tomato
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', 'room', 'gripper')

        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Move to the bin
        print("[Task] Moving to the bin at:", bin_obj)
        obs, reward, done = move(env, task, current_pos, bin_obj)

        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Drop the tomato into the bin
        print("[Task] Dropping the tomato into the bin.")
        obs, reward, done = place(env, 'tomato1', 'bin')

        if done:
            print("[Task] Task ended after placing tomato in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()