def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extract object positions for clarity
        ball1_pos = positions['ball1']
        ball2_pos = positions['ball2']
        robby_pos = positions['robby']

        # Plan Execution Example
        # Move to ball1's position
        print("[Task] Moving to ball1 at:", ball1_pos)
        obs, reward, done = move(env, robby_pos, ball1_pos)
        if done:
            print("[Task] Task ended after moving to ball1!")
            return

        # Pick ball1
        print("[Task] Picking up ball1.")
        obs, reward, done = pick(env, 'ball1', ball1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking ball1!")
            return
        
        # Move to ball2's position
        print("[Task] Moving to ball2 at:", ball2_pos)
        obs, reward, done = move(env, ball1_pos, ball2_pos)
        if done:
            print("[Task] Task ended after moving to ball2!")
            return

        # Pick ball2
        print("[Task] Picking up ball2.")
        obs, reward, done = pick(env, 'ball2', ball2_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking ball2!")
            return

        # Place ball1 in the drop location (if applicable)
        drop_location = (0, 0, 0)  # Define the drop location
        print("[Task] Placing ball1 at drop location.")
        obs, reward, done = place(env, 'ball1', drop_location)
        if done:
            print("[Task] Task ended after placing ball1!")
            return

        # Place ball2 in the drop location (if applicable)
        print("[Task] Placing ball2 at drop location.")
        obs, reward, done = place(env, 'ball2', drop_location)
        if done:
            print("[Task] Task ended after placing ball2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()