def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the locations of the objects and the robot
        room_a = "room_a"
        room_b = "room_b"
        object_1 = "rubbish"
        drawer_1 = "drawer_1"
        
        # Example task plan
        # 1) Move to the room where the rubbish is located
        print("[Task] Moving to", room_a)
        obs, reward, done = move(env, room_a, room_a)  # Assuming the robot is already in room_a
        if done:
            return

        # 2) Pick up the rubbish
        print("[Task] Picking up", object_1)
        obs, reward, done = pick(env, object_1, room_a, "gripper")  # Assuming the gripper is free
        if done:
            return
        
        # 3) Move to the drawer
        print("[Task] Moving to", drawer_1)
        obs, reward, done = move(env, room_a, room_b)  # Moving to the next room, assuming it's reachable
        if done:
            return

        # 4) Place the rubbish in the drawer
        print("[Task] Placing", object_1, "in", drawer_1)
        obs, reward, done = place(env, object_1, drawer_1)  # Drop action in the drawer
        if done:
            return

        # 5) Attempt to open the drawer
        print("[Task] Opening the drawer")
        obs, reward, done = pull(env, "gripper", drawer_1)  
        if done:
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()