def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example placeholders (Use actual object names based on your environment)
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']
        drawer_pos = positions['drawer']

        # plan execution example
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, task, 'initial_position', object_1_pos)
        
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        print("[Task] Picking object_1")
        obs, reward, done = pick(env, 'object_1', object_1_pos)

        if done:
            print("[Task] Task ended after picking object_1!")
            return
      
        print("[Task] Moving to drawer position at:", drawer_pos)
        obs, reward, done = move(env, task, object_1_pos, drawer_pos)

        if done:
            print("[Task] Task ended after moving to drawer!")
            return
      
        print("[Task] Placing object_1 in the drawer")
        obs, reward, done = place(env, 'object_1', drawer_pos)

        if done:
            print("[Task] Task ended after placing object_1!")
            return

        # Further actions can continue below...
      
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()