def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions from the retrieved data
        # Example: assuming the task involves manipulating a 'drawer' and a 'gripper'
        drawer_position = positions['drawer']
        gripper_position = positions['gripper']

        # Use the robot to first move near the drawer
        print("Moving robot to the drawer position...")
        obs, reward, done = move(env, 'robot', 'current_location', drawer_position)
        if done:
            print("[Task] Task ended after moving to drawer position!")
            return

        # After reaching the drawer, pick it up
        print("Picking up the drawer...")
        obs, reward, done = pull(env, 'robot', 'drawer', drawer_position)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return
        
        # Now, the robot could place the drawer wherever needed
        print("Placing the drawer...")
        obs, reward, done = place(env, 'drawer', 'new_location')
        if done:
            print("[Task] Task ended after placing the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()