def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Check if the required objects exist
        required_objects = ['table', 'bin', 'gripper', 'tomato1', 'rubbish']
        for obj in required_objects:
            if obj not in positions:
                print(f"Warning: {obj} not found in environment.")
                return

        # Starting actions
        gripper = 'gripper'
        robot = 'robot'
        
        # Step 1: Move to the object
        target_pos = positions['tomato1']
        print("[Task] Moving to tomato1 at:", target_pos)
        obs, reward, done = move(env, robot, obs.robot_position, target_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return
        
        # Step 2: Pick the object
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', target_pos, gripper)
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 3: Move to the bin
        target_pos = positions['bin']
        print("[Task] Moving to bin at:", target_pos)
        obs, reward, done = move(env, robot, obs.robot_position, target_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 4: Place the object
        print("[Task] Placing the tomato1 into the bin.")
        obs, reward, done = place(env, 'tomato1', target_pos)
        if done:
            print("[Task] Task ended after placing tomato1 into the bin!")
            return
        
        print("[Task] Completed all actions successfully.")
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()