def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Defining the objects being manipulated
        rubbish_pos = positions['rubbish']  # Ensure that rubbish exists in the environment
        bin_pos = positions['bin']          # Ensure that bin exists in the environment
        
        # Simulated objective: pick rubbish and place into the bin
        print("[Task] Moving to rubbish at:", rubbish_pos)
        try:
            obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=rubbish_pos)
            if done:
                print("[Task] Task ended while moving to rubbish!")
                return
            
            print("[Task] Picking up rubbish...")
            obs, reward, done = pick(env, "rubbish", rubbish_pos, obs.gripper)
            if done:
                print("[Task] Task ended while picking rubbish!")
                return
            
            print("[Task] Moving to bin at:", bin_pos)
            obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=bin_pos)
            if done:
                print("[Task] Task ended while moving to bin!")
                return
            
            print("[Task] Placing rubbish in bin...")
            obs, reward, done = place(env, "rubbish", bin_pos)
            if done:
                print("[Task] Task ended while placing rubbish!")
                return
            
            print("[Task] Successfully placed rubbish in the bin.")

        except KeyError as e:
            print(f"[Error] Missing object in environment: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()