def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming 'drawer' and 'rubbish' are the objects we need to interact with
        drawer_pos = positions['drawer']
        rubbish_pos = positions['rubbish']
        tomato_pos = positions['tomato']
        gripper_pos = positions['gripper']
        
        # Step 1: Move to the drawer
        obs, reward, done = move(env, task, gripper_pos, drawer_pos)
        if done:
            print("[Task] Task ended while moving to drawer!")
            return

        # Step 2: Open the drawer
        obs, reward, done = pick(env, "drawer_handle", drawer_pos)
        if done:
            print("[Task] Task ended while picking drawer handle!")
            return

        # Step 3: Pull the drawer open
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')  # Example parameters
        if done:
            print("[Task] Task ended while pulling drawer!")
            return

        # Step 4: Move to the rubbish
        obs, reward, done = move(env, task, drawer_pos, rubbish_pos)
        if done:
            print("[Task] Task ended while moving to rubbish!")
            return

        # Step 5: Pick the rubbish
        obs, reward, done = pick(env, "rubbish", rubbish_pos)
        if done:
            print("[Task] Task ended while picking rubbish!")
            return

        # Step 6: Move to the disposal area (not provided, assuming a position)
        disposal_pos = positions['disposal_area']
        obs, reward, done = move(env, task, rubbish_pos, disposal_pos)
        if done:
            print("[Task] Task ended while moving to disposal area!")
            return

        # Step 7: Drop the rubbish in the disposal area
        obs, reward, done = place(env, "rubbish", disposal_pos)
        if done:
            print("[Task] Task ended while dropping rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()