def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Example: Define the positions of the objects and gripper
        drawer_position = positions['drawer']
        robot_position = positions['robot']
        gripper = 'gripper_1'
        
        # Step 1: Move to the location of the drawer
        print("[Task] Moving to drawer position:", drawer_position)
        obs = move(env, robot_position, drawer_position)
        
        # Step 2: Rotate the gripper to the desired angle
        target_angle = 'ninety_deg'  # Example target angle for the gripper
        print(f"[Task] Rotating gripper to {target_angle}.")
        obs, reward, done = rotate(env, task, target_angle)
        
        # Step 3: Pick the drawer
        print("[Task] Picking the drawer.")
        obs = pick(env, 'drawer', drawer_position, gripper)
        
        # Step 4: Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs = pull(env, gripper, 'drawer')
        
        # Step 5: Place the object inside the drawer
        object_to_place = 'object_1'  # Example object to place
        print(f"[Task] Placing {object_to_place} in the drawer.")
        obs = place(env, object_to_place, drawer_position)
        
        # Complete the task
        print("[Task] Task completed successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()