def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Example object references from positions
        robot = 'robot'
        location_home = 'home'
        location_drawer = 'drawer_location'  # Adjust with actual drawer location from positions
        object_item = 'item_name'  # Adjust with actual item name from positions
        
        # Step 1: Move to the drawer area
        print("[Task] Moving to drawer area.")
        obs, reward, done = move(env, robot, location_home, location_drawer)
        if done:
            print("[Task] Task ended during moving to drawer!")
            return

        # Step 2: Open the drawer
        print("[Task] Opening the drawer.")
        obs, reward, done = rotate(env, robot, target_quat, max_steps=100)  # target_quat should be defined properly
        if done:
            print("[Task] Task ended during opening drawer!")
            return
        
        # Step 3: Pick the item from the opened drawer
        print("[Task] Picking the item from the drawer.")
        obs, reward, done = pick(env, object_item, location_drawer, robot)
        if done:
            print("[Task] Task ended during picking item!")
            return

        # Step 4: Move to another location with the item
        print("[Task] Moving to another location with the item.")
        new_location = 'another_location'  # Adjust with actual new location from positions
        obs, reward, done = move(env, robot, location_drawer, new_location)
        if done:
            print("[Task] Task ended during moving with item!")
            return

        # Step 5: Place the item at the new location
        print("[Task] Placing the item.")
        obs, reward, done = place(env, object_item, new_location)
        if done:
            print("[Task] Task ended during placing item!")
            return
            
        # Final cleanup or task completion
        print("[Task] Task completed successfully.")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()