def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example variables for interaction:
        gripper = "gripper"  # Assuming we have a single gripper
        drawer = "drawer"  # Assuming there is a specific drawer object
        object_to_pick = "object"  # Replace with actual object identifier
        location = "location"  # Replace with the actual location identifier

        # Approach and pick the object
        print(f"[Task] Picking object at location: {positions[object_to_pick]}")
        obs, reward, done = pick(env, object_to_pick, location, gripper)
        
        if done:
            print("[Task] Task ended after picking the object!")
            return
        
        # Move gripper to the side position of the drawer
        side_position = "side_pos"  # Replace with the actual side position identifier
        print(f"[Task] Moving gripper to side position: {side_position}")
        obs, reward, done = move_to_side(env, gripper, drawer, positions[gripper], side_position)
        
        if done:
            print("[Task] Task ended after moving to side position!")
            return
        
        # Pick the drawer
        print(f"[Task] Picking the drawer: {drawer}")
        obs, reward, done = pick_drawer(env, gripper, drawer, side_position)
        
        if done:
            print("[Task] Task ended after picking the drawer!")
            return
        
        # Open the drawer
        print(f"[Task] Opening the drawer: {drawer}")
        obs, reward, done = pull(env, gripper, drawer)
        
        if done:
            print("[Task] Task ended after opening the drawer!")
            return

        # Place the object inside the drawer
        print(f"[Task] Placing object inside the drawer: {drawer}")
        obs, reward, done = place(env, object_to_pick, drawer)
        
        if done:
            print("[Task] Task ended after placing the object in the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()