def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve Object Positions
        positions = get_object_positions()

        # Example Execution Plan
        try:
            # Move robot to the first object location
            robot_location = positions.get('rooma')  # Example location
            if robot_location:
                obs, reward, done = move(env, robot_location, 'rooma')
                if done:
                    print("[Task] Early exit after moving to location!")
                    return

            # Pick the object at that location
            obj1_location = positions.get('ball1')
            if obj1_location:
                obs, reward, done = pick(env, 'ball1', 'rooma', 'gripper')
                if done:
                    print("[Task] Early exit after picking object!")
                    return

            # Move to another location to place the object
            move_location = positions.get('roomb')
            if move_location:
                obs, reward, done = move(env, 'rooma', move_location)
                if done:
                    print("[Task] Early exit after moving to place!")
                    return

            # Place the object at the new location
            obs, reward, done = place(env, 'ball1', 'roomb')
            if done:
                print("[Task] Task ended after placing object!")
                return

        except Exception as e:
            print(f"[Error] An exception occurred: {str(e)}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()