def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Placeholder for objects based on positions
        # Example:
        # object_1_pos = positions['object_1']
        # object_2_pos = positions['object_2']
        
        # Here, we replace object keys with actual objects from the environment
        object_key = 'object_key' # Replace with actual key
        drawer_key = 'drawer_key' # Replace with actual key
        gripper_key = 'gripper_key' # Replace with actual gripper reference
        object_pos = positions[object_key]
        drawer_pos = positions[drawer_key]

        # Start executing the plan
        # Move to the object's location
        print(f"[Task] Moving to {object_key} at:", object_pos)
        obs, reward, done = move(env, obs.robot_location, object_pos)
        if done:
            print("[Task] Task ended after moving to the object!")
            return
        
        # Pick the object
        print(f"[Task] Picking {object_key}")
        obs, reward, done = pick(env, object_key, object_pos, gripper_key)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Move to the drawer's side position
        side_position = 'side_position'  # Specify the actual side position from PDDL
        print(f"[Task] Moving gripper to side position {side_position}")
        obs, reward, done = move(env, obs.gripper_location, side_position)
        if done:
            print("[Task] Task ended after moving to side position!")
            return
        
        # Pick the drawer
        print(f"[Task] Picking drawer at {drawer_pos}")
        obs, reward, done = pick(env, drawer_key, drawer_pos, gripper_key)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return
        
        # Pull the drawer
        print(f"[Task] Pulling the drawer {drawer_key}")
        obs, reward, done = pull(env, drawer_key, drawer_pos)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Place the object in the drawer
        print(f"[Task] Placing {object_key} in the drawer")
        obs, reward, done = place(env, object_key, drawer_pos)
        if done:
            print("[Task] Task ended after placing the object!")
            return
        
        print("[Task] Complete task execution.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()