def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming the gripper 'g' has to interact with a drawer 'd'
        gripper = 'gripper_1'
        drawer = 'drawer_1'
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_anchor_pos = positions['top_anchor_pos']
        
        # Plan Execution
        # Step 1: Move to the bottom anchor position
        print("[Task] Moving to bottom anchor position...")
        move(env, 'initial_position', bottom_anchor_pos)
        
        # Step 2: Pick the drawer at the bottom anchor position
        print("[Task] Picking the drawer...")
        pick(env, drawer, bottom_anchor_pos, gripper)
        
        # Step 3: Open the drawer
        print("[Task] Opening the drawer...")
        pull(env, gripper, drawer)
        
        # Step 4: Move to the middle anchor position
        print("[Task] Moving to middle anchor position...")
        move(env, bottom_anchor_pos, middle_anchor_pos)
        
        # Step 5: Pick the drawer at the middle anchor position
        print("[Task] Picking the drawer...")
        pick(env, drawer, middle_anchor_pos, gripper)

        # Step 6: Open the drawer
        print("[Task] Opening the drawer...")
        pull(env, gripper, drawer)
        
        # Step 7: Move to the top anchor position
        print("[Task] Moving to top anchor position...")
        move(env, middle_anchor_pos, top_anchor_pos)
        
        # Step 8: Pick the drawer at the top anchor position
        print("[Task] Picking the drawer...")
        pick(env, drawer, top_anchor_pos, gripper)

        # Step 9: Open the drawer
        print("[Task] Opening the drawer...")
        pull(env, gripper, drawer)

    except Exception as e:
        print(f"[Error] An exception occurred: {e}")
    
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()