def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions; you need to replace these keys with actual objects
        object_1_pos = positions['object_1']  # Replace with actual object name
        object_2_pos = positions['object_2']  # Replace with actual object name

        # Step 1: Move to object_1
        print(f"[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, "current_room", "room_with_object_1")  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Step 2: Pick object_1
        print(f"[Task] Picking object_1 at:", object_1_pos)
        obs, reward, done = pick(env, 'object_1', 'room_with_object_1', 'gripper')  # Replace with actual gripper name
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to object_2
        print(f"[Task] Moving to object_2 at:", object_2_pos)
        obs, reward, done = move(env, "room_with_object_1", "room_with_object_2")  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to object_2!")
            return

        # Step 4: Place object_1 at object_2 location
        print(f"[Task] Placing object_1 at:", object_2_pos)
        obs, reward, done = place(env, 'object_1', 'room_with_object_2')  # Replace with actual placement location
        if done:
            print("[Task] Task ended after placing object_1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()