def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Verify all important objects are present
        required_objects = ['drawer1', 'drawer2', 'rubbish_bin']
        for obj in required_objects:
            if obj not in positions:
                raise ValueError(f"Missing object: {obj} not found in the environment")

        # Assume drawer1 and rubbish_bin are positions for simplicity
        drawer_position = positions['drawer1']
        rubbish_bin_position = positions['rubbish_bin']

        # Step 1: Move to the first drawer's position
        print("[Task] Moving to drawer position:", drawer_position)
        move(env, drawer_position, drawer_position)  # Adjust this function call as needed

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer")
        pick(env, 'drawer1', drawer_position, 'right')  # Specify the gripper

        # Step 3: Pull the drawer open if it's not locked
        print("[Task] Attempting to pull the drawer open")
        if not obs['is_locked']:  # Assuming this information is in the obs
            pull(env, 'drawer1')  # Assuming the robot is holding the handle
    
        # Step 4: Check the state of the drawer and see if rubbish is present
        if obs['rubbish_present']:  # Assuming this is part of observation
            # Step 5: Pick up the rubbish
            print("[Task] Picking up the rubbish")
            pick(env, 'rubbish', drawer_position, 'right')

            # Step 6: Move to the rubbish bin
            print("[Task] Moving to the rubbish bin position:", rubbish_bin_position)
            move(env, drawer_position, rubbish_bin_position)  # Move to bin

            # Step 7: Drop the rubbish into the bin
            print("[Task] Dropping rubbish into the bin")
            place(env, 'rubbish', rubbish_bin_position)

        print("[Task] Task completed!")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")
    
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()