def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming drawer position is 'drawer_position' and gripper 'main_gripper'
        drawer_position = positions['drawer']  # Update with actual drawer key
        main_gripper = 'main_gripper'  # Update with actual gripper ID
        
        # 1. Move to drawer side position
        print("[Task] Moving to drawer side position.")
        obs, reward, done = move(env, main_gripper, 'initial_position', drawer_position)
        if done: return

        # 2. Rotate gripper to be able to pick the drawer handle
        print("[Task] Rotating gripper to pick the drawer.")
        target_quat = [0, 0, 0, 1]  # Adjust to desired quaternion for position
        obs, reward, done = rotate(env, task, target_quat)
        if done: return

        # 3. Pick the drawer handle
        print("[Task] Picking the drawer handle.")
        obs, reward, done = pick(env, 'drawer_handle', drawer_position, main_gripper)
        if done: return

        # 4. Pull the drawer open
        print("[Task] Pulling the drawer open.")
        obs, reward, done = pull(env, main_gripper, 'drawer')
        if done: return
        
        # 5. Place the item in the drawer if necessary
        # Assuming item is 'item_to_place' located at 'item_position'
        item_to_place = positions['item_to_place']  # Update with actual item key
        print("[Task] Placing the item in the drawer.")
        obs, reward, done = place(env, item_to_place, 'drawer_inside_position')
        if done: return

    except Exception as e:
        print(f"An error occurred: {str(e)}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()