def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assume we have two objects: "drawer" and "item"
        drawer_position = positions.get('drawer', None)
        item_position = positions.get('item', None)

        if drawer_position is None or item_position is None:
            print("One of the required objects is not present in the environment!")
            return

        # === Plan Execution ===

        # Move to the location of the item
        print("[Task] Moving to the item.")
        obs, reward, done = move(env, "room", "item_room")  # Example rooms, adjust as needed
        if done:
            print("[Task] Task ended while moving to the item!")
            return

        # Pick up the item
        print("[Task] Picking the item.")
        obs, reward, done = pick(env, "item", "item_room", "gripper")
        if done:
            print("[Task] Task ended after picking the item!")
            return

        # Move to the drawer
        print("[Task] Moving to the drawer.")
        obs, reward, done = move(env, "item_room", "drawer_room")  # Move to drawer room
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return

        # Place the item in the drawer
        print("[Task] Placing the item in the drawer.")
        obs, reward, done = place(env, "item", "drawer_room")
        if done:
            print("[Task] Task ended after placing the item!")
            return

        print("[Task] Task completed successfully.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()