def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming object positions received are in the format:
        # positions = {'drawer': (x1, y1, z1), 'object': (x2, y2, z2), ...}
        drawer_pos = positions['drawer']  # Replace with actual drawer object name
        object_pos = positions['object']   # Replace with actual object

        # Approach the drawer and pick it
        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, task, obs.position, drawer_pos)
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return
        
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, 'drawer', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended while picking the drawer!")
            return
        
        # Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, 'gripper', 'drawer')
        if done:
            print("[Task] Task ended while pulling the drawer!")
            return
      
        # Move to the object to pick it
        print("[Task] Moving to object position:", object_pos)
        obs, reward, done = move(env, task, drawer_pos, object_pos)
        if done:
            print("[Task] Task ended while moving to the object!")
            return

        print("[Task] Picking the object.")
        obs, reward, done = pick(env, 'object', object_pos, 'gripper')
        if done:
            print("[Task] Task ended while picking the object!")
            return
        
        # Place the object back into a designated space (e.g., the drawer)
        print("[Task] Placing the object back into the drawer.")
        obs, reward, done = place(env, 'object', drawer_pos)
        if done:
            print("[Task] Task ended while placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()