def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assume we have an object to interact with, e.g. 'object_1'
        object_1_pos = positions['object_1']

        # Step 1: Move to the location of the object
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, "current_location", object_1_pos)

        if done:
            print("[Task] Task ended after moving to object_1!")
            return
        
        # Step 2: Pick the object
        print("[Task] Picking object_1")
        obs, reward, done = pick(env, "object_1", object_1_pos, "gripper")

        if done:
            print("[Task] Task ended after picking object_1!")
            return
        
        # Step 3: Move to the drop position (let's assume it's at 'drop_location')
        drop_location = positions['drop_location']
        print("[Task] Moving to drop location:", drop_location)
        obs, reward, done = move(env, object_1_pos, drop_location)

        if done:
            print("[Task] Task ended after moving to drop location!")
            return
        
        # Step 4: Place the object at drop location
        print("[Task] Placing object_1 at drop location")
        obs, reward, done = place(env, "object_1", drop_location)

        if done:
            print("[Task] Task ended after placing object_1 at drop location!")
            return
            
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()