def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # Retrieve Object Positions
        positions = get_object_positions()

        # Ensure all objects are present
        required_objects = ['rubbish', 'drawer']
        for obj in required_objects:
            if obj not in positions:
                print(f"[Error] {obj} not found in the environment. Aborting...")
                return

        # Example of executing the plan (adjust as necessary)
        # 1) Move to the location of the drawer
        drawer_pos = positions['drawer']
        obs, reward, done = move(env, 'current_room', drawer_pos)
        if done: return

        # 2) "Pick" action for drawer (assuming gripper is at the drawer)
        obs, reward, done = pick(env, 'drawer', drawer_pos, 'gripper')
        if done: return

        # 3) "Pull" action to open the drawer
        obs, reward, done = pull(env, 'gripper', 'drawer')
        if done: return

        # 4) Pick up the rubbish from the drawer
        rubbish_pos = positions['rubbish']
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, 'gripper')
        if done: return

        # 5) Place the rubbish back or in another designated location
        place_pos = 'disposal_location'  # Define appropriate location
        obs, reward, done = place(env, 'rubbish', place_pos)
        if done: return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()