def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object names based on retrieval, replace with actual keys
        obj1 = 'rubbish'
        room1 = 'rooma'
        
        # Check if the object is in the initial position
        if 'rubbish' in positions:
            rubbish_pos = positions[obj1]
            print(f"[Task] Rubbish is located at: {rubbish_pos}")
            
            # Move to the rubbish location
            print(f"[Task] Moving to {rubbish_pos}")
            obs, reward, done = move(env, room1, rubbish_pos)
            if done:
                return
            
            # Pick up the rubbish
            print(f"[Task] Picking up rubbish at {rubbish_pos}")
            obs, reward, done = pick(env, obj1, room1)
            if done:
                return

            # Place the rubbish in a designated disposal area (assuming disposal_area_pos is defined)
            disposal_area_pos = (1, 1, 0)  # Replace these with actual disposal area coordinates.
            print(f"[Task] Moving to disposal area at {disposal_area_pos}")
            obs, reward, done = move(env, rubbish_pos, disposal_area_pos)
            if done:
                return
            
            print(f"[Task] Placing rubbish at {disposal_area_pos}")
            obs, reward, done = place(env, obj1, disposal_area_pos)
            if done:
                return

        else:
            print("[Task] Rubbish not found in the environment!")

    except Exception as e:
        print(f"An error occurred: {e}")
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()