def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions (Replace with correct keys)
        object_1_pos = positions['object_1']  # Placeholder for actual object key
        object_2_pos = positions['object_2']  # Placeholder for actual object key
        drawer_pos = positions['drawer']      # Placeholder for drawer position

        # Plan Execution
        # 1) Move to the first object
        print("[Task] Moving to object 1 at:", object_1_pos)
        obs, reward, done = move(env, 'initial_room', object_1_pos)
        if done:
            print("[Task] Task ended after moving to object 1!")
            return

        # 2) Pick the first object
        print("[Task] Picking object 1.")
        obs, reward, done = pick(env, 'object_1', 'current_room')
        if done:
            print("[Task] Task ended after picking object 1!")
            return
        
        # 3) Move to the drawer
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, 'current_room', drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return
        
        # 4) Place the object in the drawer
        print("[Task] Placing object 1 in the drawer.")
        obs, reward, done = place(env, 'object_1', 'drawer')
        if done:
            print("[Task] Task ended after placing object 1!")
            return

        # 5) Rotate the gripper to interact with the drawer
        print("[Task] Rotating the gripper.")
        obs, reward, done = rotate(env, task, 'target_quaternion')  # Replace with actual quaternion
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()