def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming positions include 'drawer', 'bin', and 'rubbish'
        drawer_pos = positions['drawer']
        bin_pos = positions['bin']
        rubbish_pos = positions['rubbish']

        # Step 1: Move to the drawer to pick it
        print("[Task] Approaching drawer at:", drawer_pos)
        obs, reward, done = move(env, 'starting_position', drawer_pos)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 2: Pick the drawer handle
        print("[Task] Picking the drawer handle")
        obs, reward, done = pick(env, 'drawer_handle', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer handle!")
            return 
        
        # Step 3: Pull the drawer open
        print("[Task] Pulling the drawer open")
        obs, reward, done = pull(env, 'gripper', 'drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return 
        
        # Step 4: Check for rubbish and pick it up
        print("[Task] Checking for rubbish")
        if 'rubbish' in positions:
            print("[Task] Picking rubbish")
            obs, reward, done = pick(env, 'rubbish', rubbish_pos, 'gripper')
            if done:
                print("[Task] Task ended after picking the rubbish!")
                return 
        
        # Step 5: Place rubbish into the bin
        print("[Task] Placing rubbish into the bin")
        obs, reward, done = place(env, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended after placing rubbish in the bin!")
            return 

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()