def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the objects based on retrieval
        obj1_pos = positions['object1']
        obj2_pos = positions['object2']
        room = positions['room']

        # 1) Approach and pick the first object (object1)
        print("[Task] Approaching object 1 at:", obj1_pos)
        obs, reward, done = move(env, task, current_location, obj1_pos)
        
        if done:
            print("[Task] Task ended while moving to object 1!")
            return
        
        # 2) Pick object 1
        print("[Task] Picking object 1.")
        obs, reward, done = pick(env, "object1", room, "gripper")
        
        if done:
            print("[Task] Task ended after picking object 1!")
            return

        # 3) Move to the drop location
        print("[Task] Moving to drop location.")
        obs, reward, done = move(env, task, object1_pos, drop_location)
        
        if done:
            print("[Task] Task ended while moving to the drop location!")
            return
        
        # 4) Place the object
        print("[Task] Placing object 1 at the drop location.")
        obs, reward, done = place(env, "object1", drop_location)
        
        if done:
            print("[Task] Task ended after placing object 1!")
            return

        # Repeat for object 2 following similar logic
        print("[Task] Approaching object 2 at:", obj2_pos)
        obs, reward, done = move(env, task, drop_location, obj2_pos)
        
        if done:
            print("[Task] Task ended while moving to object 2!")
            return

        print("[Task] Picking object 2.")
        obs, reward, done = pick(env, "object2", room, "gripper")
        
        if done:
            print("[Task] Task ended after picking object 2!")
            return
            
        print("[Task] Moving to drop location.")
        obs, reward, done = move(env, task, obj2_pos, drop_location)
        
        if done:
            print("[Task] Task ended while moving to the drop location for object 2!")
            return
        
        print("[Task] Placing object 2 at the drop location.")
        obs, reward, done = place(env, "object2", drop_location)
        
        if done:
            print("[Task] Task ended after placing object 2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()