import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Available skills: pick, place, move, rotate, pull

from video import init_video_writers, recording_step, recording_get_observation

# This module is assumed to provide object positions or other info about the environment
from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Extract necessary positions from the retrieved object positions
        plate_pos = positions['plate']
        bottom_side_pos = positions['bottom_side_pos']
        
        # Step 1: Open the drawer by pulling
        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return
        
        # Step 2: Place all tomatoes on the plate
        for tomato in ['tomato1', 'tomato2']:  # Use the correct names
            # Move to the tomato's position
            tomato_pos = positions[tomato]
            print(f"[Task] Picking {tomato} at {tomato_pos}.")
            obs, reward, done = pick(env, task, target_pos=tomato_pos, approach_distance=0.15)
            if done:
                print(f"[Task] Task ended after picking {tomato}!")
                return
            
            print(f"[Task] Placing {tomato} on the plate at {plate_pos}.")
            obs, reward, done = place(env, task, target_pos=plate_pos, approach_distance=0.15)
            if done:
                print(f"[Task] Task ended after placing {tomato}!")
                return
            
        print("[Task] All tomatoes placed on the plate successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()