import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Plan Execution ===
        # Step 1: Rotate gripper to 90 degrees
        rotate(env, task, target_quat=np.array([0, 0, np.sqrt(2)/2, np.sqrt(2)/2]), max_steps=100, threshold=0.05)

        # Step 2: Move to the side position of the middle drawer
        move(env, task, target_pos=positions['middle_side_pos'], max_steps=100, threshold=0.01)

        # Step 3: Move to the anchor position of the middle drawer
        move(env, task, target_pos=positions['middle_anchor_pos'], max_steps=100, threshold=0.01)

        # Step 4: Pick the middle drawer using the gripper
        pick_drawer(env, task, g="gripper", d="middle", p="middle_anchor_pos")

        # Step 5: Pull the middle drawer open fully
        pull(env, task, pull_distance=0.3)  # Assuming a distance to fully open the drawer.

        # Step 6: Pick tomato1 from the table using the gripper
        pick(env, task, target_pos=positions['tomato1'], max_steps=100, threshold=0.01)

        # Step 7: Place tomato1 on the plate
        place(env, task, target_pos=positions['plate'], max_steps=100, threshold=0.01)

        # Step 8: Pick tomato2 from the table using the gripper
        pick(env, task, target_pos=positions['tomato2'], max_steps=100, threshold=0.01)

        # Step 9: Place tomato2 on the plate
        place(env, task, target_pos=positions['plate'], max_steps=100, threshold=0.01)

    except Exception as e:
        print("An error occurred:", e)
    
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()