import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on expected keys
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # === Task Plan Execution ===
        # Step 1: Rotate the gripper to the correct orientation for the drawer
        rotate(env, task, target_quat=np.array([0, 0, 0, 1]))  # Assuming upright orientation

        # Step 2: Move to the side position of the bottom drawer
        move(env, task, bottom_side_pos)

        # Step 3: Move to the anchor position of the bottom drawer
        move(env, task, bottom_anchor_pos)

        # Step 4: Pick the drawer with the gripper
        pick_drawer(env, task, "gripper", "bottom", bottom_anchor_pos)

        # Step 5: Pull the drawer open
        pull(env, task, pull_distance=0.2, pull_axis='y')  # Align with the specification if necessary

        # Step 6: Pick the first tomato
        pick(env, task, "tomato1", "table")

        # Step 7: Place the first tomato onto the plate
        place(env, task, "tomato1", "plate")

        # Step 8: Pick the second tomato
        pick(env, task, "tomato2", "table")

        # Step 9: Place the second tomato onto the plate
        place(env, task, "tomato2", "plate")

    except Exception as e:
        print(f"Error during task execution: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()