def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Use only proper naming for the objects from the observation
        item1_pos = positions['item1']
        item2_pos = positions['item2']

        # Example Plan Execution
        # 1) Move to item1's position and pick it
        print("[Task] Approaching item1 at:", item1_pos)
        obs, reward, done = move(env, 'current_location', item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        obs, reward, done = pick(env, 'item1', item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # 2) Move to item2's position and pick it
        print("[Task] Approaching item2 at:", item2_pos)
        obs, reward, done = move(env, 'current_location', item2_pos)
        if done:
            print("[Task] Task ended after moving to item2!")
            return

        obs, reward, done = pick(env, 'item2', item2_pos)
        if done:
            print("[Task] Task ended after picking item2!")
            return

        # 3) Place item1 and item2 in designated spots (assuming positions for the drop)
        designated_place1 = 'designated_location1'
        designated_place2 = 'designated_location2'

        print("[Task] Placing item1 at:", designated_place1)
        obs, reward, done = place(env, 'item1', designated_place1)
        if done:
            print("[Task] Task ended after placing item1!")
            return

        print("[Task] Placing item2 at:", designated_place2)
        obs, reward, done = place(env, 'item2', designated_place2)
        if done:
            print("[Task] Task ended after placing item2!")
            return

        print("[Task] All items successfully manipulated!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()