def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming positions contains 'drawer1' and 'drawer2' for demonstration
        drawer_pos = positions['drawer1']  # Just an example
        gripper_pos = positions['gripper']

        # 1) Move to the drawer position
        print("[Task] Moving to drawer position:", drawer_pos)
        obs, reward, done = move(env, gripper_pos, drawer_pos)
        if done:
            print("[Task] Task ended during move to drawer!")
            return
        
        # 2) Pick the drawer
        print("[Task] Picking the drawer...")
        obs, reward, done = pick(env, 'drawer1', drawer_pos, 'gripper')
        if done:
            print("[Task] Task ended during picking the drawer!")
            return
        
        # 3) Pull the drawer
        print("[Task] Pulling the drawer...")
        obs, reward, done = pull(env, task, pull_distance=0.5) # Example distance
        if done:
            print("[Task] Task ended during pulling the drawer!")
            return
 
        # 4) Place the drawer in a new position (for example 'disposal area')
        print("[Task] Placing the drawer in the disposal area...")
        obs, reward, done = place(env, 'drawer1', 'disposal_area')
        if done:
            print("[Task] Task ended during placing the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()