def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming you have drawer and object positions defined
        drawer_position = positions['drawer']
        object_position = positions['object']
        gripper_position = positions['gripper'] 

        # Plan Execution Sequence
        # 1) Move to the object
        print("[Task] Moving to object at:", object_position)
        obs, reward, done = move(env, gripper_position, object_position)
        if done:
            print("[Task] Task ended after moving to object!")
            return

        # 2) Pick up the object
        print("[Task] Picking up object.")
        obs, reward, done = pick(env, 'object', 'location')
        if done:
            print("[Task] Task ended after picking up object!")
            return

        # 3) Move to the drawer
        print("[Task] Moving to drawer at:", drawer_position)
        obs, reward, done = move(env, object_position, drawer_position)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # 4) Check if the drawer is locked before attempting to open
        is_locked = obs.is_locked  # Assuming proper observations are available
        if not is_locked:
            print("[Task] Opening the drawer.")
            obs, reward, done = pull(env, 'drawer')
            if done:
                print("[Task] Task ended after opening the drawer!")
                return
        else:
            print("[Task] Drawer is locked, cannot open.")

        # 5) Place the object inside the drawer
        print("[Task] Placing the object inside the drawer.")
        obs, reward, done = place(env, 'object', 'drawer')
        if done:
            print("[Task] Task ended after placing the object!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()