def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming following objects based on the problem description
        drawer_object = "drawer1"  # Example drawer to manipulate, replace with actual drawer name
        target_position = positions['object_name']  # Replace 'object_name' with actual object you need to pick
        gripper = "gripper1"  # Example gripper name
        drawer_position = positions[drawer_object]  # Replace with actual drawer name if different

        # Ensure the drawer is not locked
        print("[Task] Checking if the drawer is locked...")
        if task.is_locked(drawer_object):
            print("[Task] Drawer is locked. Attempting to unlock...")
            obs, reward, done = pull(env, task, drawer_object, drawer_position)  # Pull action to unlock
            if done:
                print("[Task] Drawer unlocked successfully!")
            else:
                print("[Task] Failed to unlock the drawer, exiting task.")
                return

        # Proceed to open the drawer
        print("[Task] Opening the drawer...")
        obs, reward, done = rotate(env, task, target_quat, ...)  # Call rotation to align if needed
        if done:
            print("[Task] Successfully rotated the gripper!")
        
        print("[Task] Moving the gripper to the side position to access the drawer.")
        obs, reward, done = move_to_side(gripper, drawer_object, current_position, drawer_position)  # Move to side

        print("[Task] Picking the target object...")
        obs, reward, done = pick(env, target_object, target_location, gripper)  # Pick action
        if done:
            print("[Task] Object picked successfully!")

        print("[Task] Placing the object to the desired location...")
        obs, reward, done = place(env, target_object, desired_location)  # Place action
        if done:
            print("[Task] Object placed at the desired location successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()