def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Check if necessary objects are present
        if 'tomato1' not in positions or 'tomato2' not in positions:
            raise ValueError("Necessary objects not present in environment")

        # Retrieve object positions for further actions
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        drawer_pos = positions['drawer']  # Assuming drawer is present
        
        print("[Task] Manipulating tomato1 at:", tomato1_pos)

        # Move to tomato1
        obs = task.get_observation()
        current_room = obs.robot_pose[0:2]  # Assuming the robot's position includes its room
        obs, reward, done = move(env, current_room, tomato1_pos)

        if done:
            print("[Task] Task ended while moving to tomato1!")
            return

        # Pick tomato1
        obs, reward, done = pick(env, 'tomato1', tomato1_pos, 'gripper')

        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Move to the drawer
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, current_room, drawer_pos)
        
        if done:
            print("[Task] Task ended while moving to drawer!")
            return

        # Open the drawer
        print("[Task] Opening drawer.")
        obs, reward, done = pull(env, 'drawer', obs)

        if done:
            print("[Task] Task ended while opening the drawer!")
            return

        # Place tomato1 inside drawer
        print("[Task] Placing tomato1 in the drawer.")
        obs, reward, done = place(env, 'tomato1', drawer_pos)

        if done:
            print("[Task] Task ended after placing tomato1 in drawer!")
            return

        # Move to tomato2
        print("[Task] Manipulating tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, current_room, tomato2_pos)

        if done:
            print("[Task] Task ended while moving to tomato2!")
            return

        # Pick tomato2
        obs, reward, done = pick(env, 'tomato2', tomato2_pos, 'gripper')

        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Move back to the drawer
        print("[Task] Moving back to drawer.")
        obs, reward, done = move(env, current_room, drawer_pos)

        if done:
            print("[Task] Task ended while moving back to drawer!")
            return

        # Place tomato2 inside drawer
        print("[Task] Placing tomato2 in the drawer.")
        obs, reward, done = place(env, 'tomato2', drawer_pos)

        if done:
            print("[Task] Task completed after placing tomato2 in drawer!")
            return

    finally:
        # Always ensure the environment is properly shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()