def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the actions based on the plan
        gripper = "gripper"  # Assuming single gripper
        drawer = "drawer"     # Use appropriate object identifiers based on actual positions
        target_position = positions.get('object_1')  # Example object
        holding_position = positions.get('holding')   # Example holding position
        drop_position = positions.get('drop')          # Example drop position

        # 1) Approach the object position
        print("[Task] Approaching target object at:", target_position)
        obs, reward, done = move(env, gripper, "current_location", target_position)
        if done:
            print("[Task] Task ended after moving to target object!")
            return

        # 2) Pick the object
        print("[Task] Picking the object.")
        obs, reward, done = pick(env, target_position, "current_location", gripper)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # 3) Move to holding position
        print("[Task] Moving to holding position.")
        obs, reward, done = move(env, target_position, holding_position)
        if done:
            print("[Task] Task ended after moving to holding position!")
            return

        # 4) Place the object
        print("[Task] Placing the object at drop position.")
        obs, reward, done = place(env, "object_1", drop_position)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()