def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Example object positions (adjust based on actual objects)
        obj1_pos = positions.get('object_1', None)
        obj2_pos = positions.get('object_2', None)

        # Example Plan Execution
        if obj1_pos:
            print("[Task] Moving to object_1 at:", obj1_pos)
            try:
                obs, reward, done = move(env, obs.robot_pos, obj1_pos)
                if done:
                    print("[Task] Task ended after moving to object_1 position!")
                    return
            except Exception as e:
                print(f"[Error] Failed to move to object_1: {e}")

            print("[Task] Picking up object_1")
            try:
                obs, reward, done = pick(env, 'object_1', obj1_pos, 'gripper')
                if done:
                    print("[Task] Task ended after picking object_1!")
                    return
            except Exception as e:
                print(f"[Error] Failed to pick object_1: {e}")

            # Assume further operations or moving to another object
            if obj2_pos:
                print("[Task] Moving to object_2 at:", obj2_pos)
                try:
                    obs, reward, done = move(env, obs.robot_pos, obj2_pos)
                    if done:
                        print("[Task] Task ended after moving to object_2 position!")
                        return
                except Exception as e:
                    print(f"[Error] Failed to move to object_2: {e}")

            print("[Task] Placing object_1 at object_2's position")
            try:
                obs, reward, done = place(env, 'object_1', obj2_pos)
                if done:
                    print("[Task] Task ended after placing object_1!")
                    return
            except Exception as e:
                print(f"[Error] Failed to place object_1: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()