def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        # Example usage: positions = 'object_1': (0,0,0), 'object_2': (1,1,1), ... (dictionary format)
        positions = get_object_positions()

        # Assuming existence of objects 'obj1', 'obj2' and related positions
        obj1_pos = positions['object_1']
        obj2_pos = positions['object_2']
        drawer_pos = positions['drawer']

        # 1) Approach and manipulate object_1
        print("[Task] Manipulating object_1 at:", obj1_pos)
        try:
            obs, reward, done = pick(env, task, obj='object_1', loc=drawer_pos)
            if done:
                print("[Task] Task ended after picking object_1!")
                return

            # 2) Place object_1 at a new location
            print("[Task] Placing object_1 back to drawer.")
            obs, reward, done = place(env, task, obj='object_1', loc=drawer_pos)
            if done:
                print("[Task] Task ended after placing object_1!")
                return

            # 3) Approach and manipulate object_2
            print("[Task] Manipulating object_2 at:", obj2_pos)
            obs, reward, done = pick(env, task, obj='object_2', loc=drawer_pos)
            if done:
                print("[Task] Task ended after picking object_2!")
                return

            # 4) Place object_2 at a new location
            print("[Task] Placing object_2 back to drawer.")
            obs, reward, done = place(env, task, obj='object_2', loc=drawer_pos)
            if done:
                print("[Task] Task ended after placing object_2!")
                return

        except Exception as e:
            print(f"[Error] An exception occurred: {e}")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()