def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assume we have a plate and tomatoes
        plate_position = positions['plate']
        tomato1_position = positions['tomato1']
        tomato2_position = positions['tomato2']
        
        # Start the plan
        print("[Task] Moving to the first tomato.")
        obs, reward, done = move(env, task, obs.robot_position, tomato1_position)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        print("[Task] Picking up the first tomato.")
        obs, reward, done = pick(env, 'tomato1', 'current_room', 'gripper')
        if done:
            print("[Task] Task ended after picking tomato1!")
            return
        
        print("[Task] Moving to the plate.")
        obs, reward, done = move(env, task, obs.robot_position, plate_position)
        if done:
            print("[Task] Task ended after moving to plate!")
            return
        
        print("[Task] Placing the first tomato on the plate.")
        obs, reward, done = place(env, 'tomato1', plate_position)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return
        
        print("[Task] Moving to the second tomato.")
        obs, reward, done = move(env, task, obs.robot_position, tomato2_position)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return
        
        print("[Task] Picking up the second tomato.")
        obs, reward, done = pick(env, 'tomato2', 'current_room', 'gripper')
        if done:
            print("[Task] Task ended after picking tomato2!")
            return
        
        print("[Task] Moving back to the plate.")
        obs, reward, done = move(env, task, obs.robot_position, plate_position)
        if done:
            print("[Task] Task ended after moving back to plate!")
            return
        
        print("[Task] Placing the second tomato on the plate.")
        obs, reward, done = place(env, 'tomato2', plate_position)
        if done:
            print("[Task] Task ended after placing tomato2 on the plate!")
            return

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()