def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the relevant objects
        tomato1_pos = positions.get('tomato1')
        tomato2_pos = positions.get('tomato2')
        plate_pos = positions.get('plate')

        # Check if objects are present
        if not tomato1_pos:
            print("Tomato1 not present in the environment.")
            return
        if not tomato2_pos:
            print("Tomato2 not present in the environment.")
            return
        if not plate_pos:
            print("Plate not present in the environment.")
            return

        # Step 1: Move to inspect tomato1
        print(f"[Task] Moving to inspect tomato1 at: {tomato1_pos}")
        move(env, 'current_room', 'room_with_tomato1')  # Define 'current_room' as appropriate
        obs, reward, done = pick(env, 'tomato1', 'room_with_tomato1', 'gripper')

        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 2: Move to inspect tomato2
        print(f"[Task] Moving to inspect tomato2 at: {tomato2_pos}")
        move(env, 'current_room', 'room_with_tomato2')  # Define 'current_room' as appropriate
        obs, reward, done = pick(env, 'tomato2', 'room_with_tomato2', 'gripper')

        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 3: Move to place both tomatoes on the plate
        print(f"[Task] Moving to place both tomatoes on the plate at: {plate_pos}")
        move(env, 'current_room', 'room_with_plate')  # Define 'current_room' as appropriate
        obs, reward, done = place(env, 'tomato1', 'plate')
        
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        obs, reward, done = place(env, 'tomato2', 'plate')
        
        if done:
            print("[Task] Task ended after placing tomato2!")
            return
        
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()