def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects and locations are as follows (example)
        object_1 = 'target_object'
        object_2 = 'drawer_handle'
        initial_location = 'start_location'
        drawer_location = 'drawer_location'
        
        # Step 1: Move to the target object's location
        print(f"[Task] Moving to {initial_location} to manipulate {object_1}")
        try:
            obs, reward, done = move(env, initial_location, positions[initial_location])
            if done:
                print("[Task] Task ended after moving!")
                return
        except Exception as e:
            print(f"[Error] Moving to {initial_location} failed: {e}")

        # Step 2: Pick the object
        print(f"[Task] Picking {object_1}")
        try:
            obs, reward, done = pick(env, object_1, positions[initial_location])
            if done:
                print("[Task] Task ended after picking the object!")
                return
        except Exception as e:
            print(f"[Error] Picking {object_1} failed: {e}")

        # Step 3: Move to the drawer location
        print(f"[Task] Moving to {drawer_location} to manipulate {object_2}")
        try:
            obs, reward, done = move(env, positions[initial_location], positions[drawer_location])
            if done:
                print("[Task] Task ended after moving to the drawer!")
                return
        except Exception as e:
            print(f"[Error] Moving to {drawer_location} failed: {e}")

        # Step 4: Pull the drawer handle
        print(f"[Task] Pulling the {object_2}")
        try:
            obs, reward, done = pull(env, object_2, positions[drawer_location])
            if done:
                print("[Task] Task ended after pulling the drawer!")
                return
        except Exception as e:
            print(f"[Error] Pulling {object_2} failed: {e}")

        # Step 5: Place the object (if applicable)
        print(f"[Task] Placing {object_1} inside the drawer")
        try:
            obs, reward, done = place(env, object_1, positions[drawer_location])
            if done:
                print("[Task] Task ended after placing the object in the drawer!")
                return
        except Exception as e:
            print(f"[Error] Placing {object_1} in the drawer failed: {e}")

    finally:
        # Always ensure the environment is properly shut down
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()