def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming object1, object2, drawer are the necessary targets with their respective positions
        object1_pos = positions['object1']  # Change 'object1' to your actual object key
        object2_pos = positions['object2']  # Change 'object2' to your actual object key
        drawer_pos = positions['drawer']     # Change 'drawer' to your actual drawer key
        
        # === Sample Task Plan ===
        print("[Task] Moving to object1 position...")
        obs, reward, done = move(env, task, object1_pos, max_steps=100, threshold=0.01)
        
        if done:
            print("[Task] Task ended after moving to object1!")
            return

        print("[Task] Picking up object1...")
        obs, reward, done = pick(env, task, obj='object1', room=drawer_pos, gripper='gripper')
        
        if done:
            print("[Task] Task ended after picking up object1!")
            return

        print("[Task] Moving to drawer position...")
        obs, reward, done = move(env, task, drawer_pos, max_steps=100, threshold=0.01)
        
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        print("[Task] Placing object1 in the drawer...")
        obs, reward, done = place(env, task, obj='object1', room=drawer_pos)

        if done:
            print("[Task] Task ended after placing object1!")
            return

        print("[Task] Moving to object2 position...")
        obs, reward, done = move(env, task, object2_pos, max_steps=100, threshold=0.01)
        
        if done:
            print("[Task] Task ended after moving to object2!")
            return

        print("[Task] Picking up object2...")
        obs, reward, done = pick(env, task, obj='object2', room=drawer_pos, gripper='gripper')

        if done:
            print("[Task] Task ended after picking up object2!")
            return

        print("[Task] Moving to drawer position...")
        obs, reward, done = move(env, task, drawer_pos, max_steps=100, threshold=0.01)
        
        if done:
            print("[Task] Task ended after moving to drawer again!")
            return

        print("[Task] Placing object2 in the drawer...")
        obs, reward, done = place(env, task, obj='object2', room=drawer_pos)

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()