def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # TODO: Replace these placeholder keys with your actual objects
        object1_pos = positions['object_1']  # Assume this is the first object we need to manipulate
        drawer_pos = positions['drawer_1']    # Example position of a drawer we might interact with
        gripper = obs.gripper_position          # Get current gripper position
        
        # Step 1: Move to the object
        print("[Task] Moving to object_1 at:", object1_pos)
        obs, reward, done = move(env, gripper, 'start_location', object1_pos)  # replace 'start_location' as needed
        if done:
            print("[Task] Task ended after moving to object_1!")
            return
        
        # Step 2: Pick up the object
        print("[Task] Picking object_1")
        obs, reward, done = pick(env, 'object_1', object1_pos, gripper)
        if done:
            print("[Task] Task ended after picking object_1!")
            return
        
        # Step 3: Move to the drawer
        print("[Task] Moving to drawer at:", drawer_pos)
        obs, reward, done = move(env, gripper, object1_pos, drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return
        
        # Step 4: Open the drawer
        print("[Task] Opening the drawer")
        obs, reward, done = pull(env, gripper, 'drawer_1')
        if done:
            print("[Task] Task ended after opening the drawer!")
            return
        
        # Step 5: Place the object in the drawer
        print("[Task] Placing object_1 in the drawer")
        obs, reward, done = place(env, 'object_1', drawer_pos)
        if done:
            print("[Task] Task ended after placing object_1 in the drawer!")
            return

        print("[Task] Completed all actions successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()