def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Example object positions (replace with actual positions):
        tomato_pos = positions['tomato']
        plate_pos = positions['plate']
        drawer_pos = positions['drawer']
        
        # Plans to complete the objective
        print("[Task] Moving to tomato position")
        obs, reward, done = move(env, task, obs.robot_position, tomato_pos)
        if done:
            print("[Task] Task ended after moving to tomato!")
            return

        print("[Task] Picking the tomato")
        obs, reward, done = pick(env, 'tomato', 'location_of_tomato', 'gripper')
        if done:
            print("[Task] Task ended after picking tomato!")
            return

        print("[Task] Moving to plate position")
        obs, reward, done = move(env, task, obs.robot_position, plate_pos)
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        print("[Task] Placing the tomato on the plate")
        obs, reward, done = place(env, 'tomato', 'location_of_plate')
        if done:
            print("[Task] Task ended after placing tomato!")
            return

        print("[Task] Opening the drawer")
        obs, reward, done = move(env, task, obs.robot_position, drawer_pos)
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        print("[Task] Picking the drawer handle")
        obs, reward, done = pick(env, 'drawer_handle', 'location_of_drawer', 'gripper')
        if done:
            print("[Task] Task ended after picking drawer handle!")
            return

        print("[Task] Pulling the drawer")
        obs, reward, done = pull(env, 'gripper', 'drawer')
        if done:
            print("[Task] Task ended after pulling drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()